/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.hammer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.SerializableRecipe;

public class HammerRecipe
extends SerializableRecipe {
    @Nonnull
    public static final HammerRecipe EMPTY = new HammerRecipe(new ResourceLocation("empty"), Ingredient.f_43901_, new ArrayList<ItemStackWithChance>());
    public static RecipeType<HammerRecipe> RECIPE_TYPE;
    @Nullable
    private static RegistryObject<ExNihiloRecipeSerializer<HammerRecipe>> serializer;
    @Nonnull
    private final List<ItemStackWithChance> output;
    @Nonnull
    private Ingredient input;

    public HammerRecipe(@Nonnull ResourceLocation id, @Nonnull Ingredient input, @Nonnull List<ItemStackWithChance> output) {
        super(ItemStack.f_41583_, RECIPE_TYPE, id);
        this.input = input;
        this.output = output;
    }

    @Nullable
    public static RegistryObject<ExNihiloRecipeSerializer<HammerRecipe>> getStaticSerializer() {
        return serializer;
    }

    public static void setSerializer(@Nonnull RegistryObject<ExNihiloRecipeSerializer<HammerRecipe>> serializer) {
        HammerRecipe.serializer = serializer;
    }

    public void addOutput(@Nonnull ItemStack output) {
        this.output.add(new ItemStackWithChance(output, 1.0f));
    }

    public void addOutput(@Nonnull ItemStack output, float chance) {
        this.output.add(new ItemStackWithChance(output, chance));
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public void setInput(@Nonnull Ingredient input) {
        this.input = input;
    }

    @Nonnull
    public List<ItemStackWithChance> getOutput() {
        return this.output;
    }

    @Nonnull
    public List<ItemStack> getOutputsWithoutChance() {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        this.output.forEach(stack -> returnList.add(stack.getStack()));
        return returnList;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nullable
    protected ExNihiloRecipeSerializer<HammerRecipe> getENSerializer() {
        if (serializer == null) {
            return null;
        }
        return (ExNihiloRecipeSerializer)((Object)serializer.get());
    }
}

